#ifndef DUNIDADESDISCO_H
    #define DUNIDADESDISCO_H

    #include "DString.h"

    namespace DWL {

        enum DEnum_UnidadDisco_Tipo {
	        DEnum_UnidadDisco_Tipo_Desconocido		= 0,
	        DEnum_UnidadDisco_Tipo_Path_Invalido	= 1,
	        DEnum_UnidadDisco_Tipo_Extraible		= 2,
	        DEnum_UnidadDisco_Tipo_Fijo				= 3,
	        DEnum_UnidadDisco_Tipo_Remoto			= 4,
	        DEnum_UnidadDisco_Tipo_CDRom			= 5,
	        DEnum_UnidadDisco_Tipo_RamDisk			= 6
        };

        class DUnidadDisco {
          public:
                                            DUnidadDisco(void) : _Numero_Serie(0), _Longitud_Componente(0), _Flags(0), _Letra(0), _Tipo_Disco(DEnum_UnidadDisco_Tipo_Desconocido) { 
							                };

							                DUnidadDisco(TCHAR *nPath) { 
								                Obtener(nPath); 
							                };

				                           ~DUnidadDisco(void) { 
						                    };

            BOOL					        Obtener(const TCHAR *nPath) {
								                _Letra = nPath[0];
								                TCHAR Nombre[MAX_PATH + 1];
								                TCHAR Tipo[512];
								                BOOL R = GetVolumeInformation(nPath, Nombre, MAX_PATH + 1, &_Numero_Serie, &_Longitud_Componente, &_Flags, Tipo, 512);
								                _Nombre_Volumen = Nombre;
								                _Tipo_Particion = Tipo;
								                _Tipo_Disco = static_cast<DEnum_UnidadDisco_Tipo>(GetDriveType(nPath));
								                if (R != FALSE) R = TRUE;
								                return R;
							                };

            const bool				        Solo_Lectura(void) {
								                if (_Flags & FILE_READ_ONLY_VOLUME) return true; 
								                return false;
        							        };

            const DWORD				        Numero_Serie(void) { 
								                return _Numero_Serie; 
							                };

            const DWORD				        Longitud_Componente(void) { 
								                return _Numero_Serie; 
							                };

            const TCHAR			           *Nombre_Volumen(void) {
								                return _Nombre_Volumen();
							                }

            const TCHAR			           *Tipo_Particion(void) {
								                return _Tipo_Particion();
							                }
							                // Retorna la letra de la unidad en mayuscula
            const TCHAR				        Letra(void) {
								                return _Letra;
							                };
            const DEnum_UnidadDisco_Tipo	Tipo_Disco(void) {
								                return _Tipo_Disco;
							                };
          private:
            DString		                   _Nombre_Volumen;
            DString	        	           _Tipo_Particion;
            DWORD			        	   _Numero_Serie;
            DWORD			        	   _Longitud_Componente;
            DWORD			        	   _Flags;
            TCHAR				           _Letra;
            DEnum_UnidadDisco_Tipo         _Tipo_Disco;
        };



        class DUnidadesDisco {
          public :
								            DUnidadesDisco(void) { 
								            };

			                               ~DUnidadesDisco(void) { 
								               BorrarMemoria();
								            };
								            // Mira las unidades locales de la 'C' a la 'Z' evitando las disqueteras.
            const unsigned int			    Escanear_Unidades_Locales(void) {
									            BorrarMemoria();
									            TCHAR Path[4];
									            BOOL  Exito = FALSE;
									            DWLStrCopy(Path, 4, TEXT("?:\\"));
									            DUnidadDisco *Unidad = new DUnidadDisco;
									            for (TCHAR n = TEXT('C'); n < TEXT('Z'); n++) {
										            Path[0] = n;
										            Exito = Unidad->Obtener(Path);
										            if (Exito == TRUE) {
											            _Unidades.push_back(Unidad);
											            Unidad = new DUnidadDisco;
										            }
									            }
									            delete Unidad;
									            return static_cast<unsigned int>(_Unidades.size());
								            };

            DUnidadDisco			       *Unidad(const int Pos) {
									            return _Unidades[Pos];
								            };

            DUnidadDisco			       *Buscar_Numero_Serie(const DWORD Numero) {
									            for (size_t n = 0; n < _Unidades.size(); n++) {
										            if (_Unidades[n]->Numero_Serie() == Numero) return _Unidades[n];
									            }
									            return NULL;
								            };

            DUnidadDisco			       *Buscar_Letra(const TCHAR Letra) {
									            TCHAR L2 = toupper(Letra);
									            for (size_t n = 0; n < _Unidades.size(); n++) {
										            if (_Unidades[n]->Letra() == L2) return _Unidades[n];
									            }
									            return NULL;
								            };

            const UINT      			    TotalUnidades(void) {
									            return static_cast<UINT>(_Unidades.size());
								            };
          private :
            void							BorrarMemoria(void) {
									            for (size_t n = 0; n < _Unidades.size(); n++) delete _Unidades[n];
									            _Unidades.resize(0);
								            };

            std::vector<DUnidadDisco *>    _Unidades;
        };

    };

#endif